import { StudentVerificationData } from '@/types/student-verification';

export interface ValidationResult {
  isValid: boolean;
  errors: string[];
}

export function validateStudentData(data: StudentVerificationData): ValidationResult {
  const errors: string[] = [];

  // 1. Identity
  if (!data.firstName?.trim()) errors.push("First Name is required");
  if (!data.lastName?.trim()) errors.push("Last Name is required");
  if (!data.dob) errors.push("Date of Birth is required");
  if (!data.studentId?.trim()) errors.push("Student ID is required");
  if (!data.email?.trim()) errors.push("Contact Email is required");

  // 2. Enrollment
  if (!data.institutionName) errors.push("Institution Name is required");
  if (!data.programName?.trim()) errors.push("Program Name is required");
  if (!data.termName?.trim()) errors.push("Term Name is required");
  if (!data.termStartDate) errors.push("Term Start Date is required");
  if (!data.termEndDate) errors.push("Term End Date is required");
  
  // 3. Courses (if schedule is included)
  if (data.includeClassSchedule && (!data.courses || data.courses.length === 0)) {
    errors.push("Class Schedule is enabled but no courses added");
  }

  // 4. Transcript (if included)
  if (data.includeTranscript && (!data.transcriptEntries || data.transcriptEntries.length === 0)) {
    errors.push("Academic Transcript is enabled but no entries added");
  }

  // 5. Fees (if included) - Simple check for now
  if (data.includeTuitionReceipt && (!data.tuitionItems || data.tuitionItems.length === 0)) {
    errors.push("Tuition Receipt is enabled but no fee items added");
  }

  return {
    isValid: errors.length === 0,
    errors
  };
}
