export type TemplateType = 'INSTITUTION' | 'PACKET_PRESET' | 'MILITARY_UNIT';

export interface BaseTemplate {
  id: string;
  name: string; // User friendly name e.g. "University of Washington"
  type: TemplateType;
  createdAt: string;
  isLocked?: boolean; // If true, cannot be deleted (default templates)
}

export interface InstitutionTemplate extends BaseTemplate {
  type: 'INSTITUTION';
  data: {
    name: string;
    addressLine1?: string;
    addressLine2?: string;
    registrarName?: string;
    registrarTitle?: string;
    logo?: string; // base64 string
  };
}

export interface PacketPresetTemplate extends BaseTemplate {
  type: 'PACKET_PRESET';
  data: {
    programName?: string;
    includedDocuments: string[]; // List of document IDs/Keys enabled
    pdfSettings?: {
        paperSize?: 'LETTER' | 'A4';
        margins?: 'NORMAL' | 'COMPACT';
        watermarkIntensity?: 'LIGHT' | 'MEDIUM' | 'STRONG';
        includePageNumbers?: boolean;
        showPacketId?: boolean;
        includeSectionDividers?: boolean;
        includeTableOfContents?: boolean;
    }
  };
}

export interface MilitaryUnitTemplate extends BaseTemplate {
    type: 'MILITARY_UNIT';
    data: {
        branch: string;
        unitName: string;
        recruitmentCenter?: string;
        baseAddress?: string;
        officialName?: string;
    }
}

export type Template = InstitutionTemplate | PacketPresetTemplate | MilitaryUnitTemplate;

export const STORAGE_KEY_TEMPLATES = 'genekei_templates';
