export interface Course {
  id: string;
  code: string;
  title: string;
  instructor: string;
  days: string;
  time: string;
  room: string;
  credits: number;
}

export interface ReceiptItem {
  id: string;
  description: string;
  amount: number;
}

export interface TranscriptEntry {
  id: string;
  term: string;
  course: string;
  credits: number;
  grade: string;
}

export interface StudentVerificationData {
  // Identity
  firstName: string;
  lastName: string;
  dob: Date | null;
  studentId: string;
  email: string;

  // Academic Enrollment
  institutionName: string;
  campus?: string;
  programName: string;
  credentialType: 'Diploma' | 'Associate' | 'Bachelor' | 'Master' | 'Certificate' | 'Professional License';
  enrollmentStatus: 'Active' | 'On Leave' | 'Graduated' | 'Withdrawn';
  termName: string;
  termStartDate: Date | null;
  termEndDate: Date | null;
  creditsThisTerm: number;
  expectedGraduationDate?: Date | null;
  registrarContact?: string;

  // Document Toggles
  includeIdCard: boolean;
  includeEnrollmentLetter: boolean;
  includeClassSchedule: boolean;
  includeTuitionReceipt: boolean;
  includeTranscript: boolean;
  includeRegistrationReceipt: boolean;
  includeGoodStandingLetter: boolean;
  includeFinancialStatement: boolean;

  // Data for Auto-Populate / Editors
  courses: Course[];
  tuitionItems: ReceiptItem[];
  registrationItems: ReceiptItem[];
  transcriptEntries: TranscriptEntry[];
  
  // Custom Assets (Data URLs)
  institutionSeal?: string;
  studentPhoto?: string;
}

export const DEFAULT_INSTITUTIONS = [
  // Ivy League & Prestigious US
  "Harvard University",
  "Yale University",
  "Princeton University",
  "Columbia University",
  "University of Pennsylvania",
  "Brown University",
  "Dartmouth College",
  "Cornell University",
  "Massachusetts Institute of Technology (MIT)",
  "Stanford University",
  "California Institute of Technology (Caltech)",
  "University of Chicago",
  "Johns Hopkins University",
  "Duke University",
  "Northwestern University",
  "Vanderbilt University",
  "Rice University",
  "Washington University in St. Louis",
  "University of Notre Dame",
  "Georgetown University",
  "Emory University",
  "Carnegie Mellon University",
  "University of Southern California (USC)",
  "New York University (NYU)",
  "Tufts University",
  "Boston University",
  "Boston College",
  "Northeastern University",

  // Major Public Universities (US)
  "University of California, Berkeley",
  "University of California, Los Angeles (UCLA)",
  "University of California, San Diego (UCSD)",
  "University of California, Davis",
  "University of Michigan-Ann Arbor",
  "University of Virginia",
  "University of North Carolina at Chapel Hill",
  "University of Florida",
  "University of Texas at Austin",
  "Georgia Institute of Technology",
  "University of Washington",
  "University of Wisconsin-Madison",
  "University of Illinois Urbana-Champaign",
  "Ohio State University",
  "University of Maryland, College Park",
  "Purdue University",
  "Texas A&M University",
  "University of Minnesota Twin Cities",
  "Michigan State University",
  "Penn State University",
  "Rutgers University-New Brunswick",
  "University of Arizona",
  "Arizona State University",
  "University of Colorado Boulder",
  "Indiana University Bloomington",
  "University of Iowa",
  "University of Kansas",
  "University of Kentucky",
  "Louisiana State University",
  "University of Massachusetts Amherst",
  "University of Missouri",
  "University of Nebraska-Lincoln",
  "University of Oklahoma",
  "University of Oregon",
  "University of Pittsburgh",
  "University of South Carolina",
  "University of Tennessee, Knoxville",
  "University of Utah",
  "Virginia Tech",

  // International & Others (Source: SheerID)
  "University of Oxford",
  "University of Cambridge",
  "Imperial College London",
  "University of Toronto",
  "McGill University",
  "University of British Columbia",
  "ETH Zurich - Swiss Federal Institute of Technology",
  "Universidad Nacional de Educación a Distancia (UNED)",
  "Universidad Autónoma de Madrid",
  "University of Tokyo",
  "University of Melbourne",
  "University of Sydney",
  "National University of Singapore",
  "Tsinghua University",
  "Peking University",
  "A T Still University of Health Sciences",
  "Alabama A & M University",
  "Amridge University",
  "Ball State University",
  "Baptist Health College",
  "Case Western Reserve University",
  "Florida State University",
  "Harvey Mudd College",
  "Illinois Institute of Technology",
  "Kansas State University",
  "Liberty University",
  "Loyola University Chicago",
  "Oklahoma State University",
  "Pepperdine University",
  "Temple University",
  "Wake Forest University"
];

export const CREDENTIAL_TYPES = [
  'Diploma',
  'Associate',
  'Bachelor',
  'Master',
  'Certificate',
  'Professional License'
] as const;

export interface PdfSettings {
  paperSize: 'LETTER' | 'A4';
  margins: 'NORMAL' | 'COMPACT';
  includePageNumbers: boolean;
  showPacketId: boolean;
  includeSectionDividers: boolean;
  includeTableOfContents: boolean;
}

export interface IdCardSettings {
  theme: 'LIGHT' | 'DARK' | 'HIGH_CONTRAST' | 'MINIMAL';
  barcodeType: 'QR' | 'CODE128' | 'BOTH';
  expirationMode: 'FIXED' | 'AUTO'; // Fixed = specific date, Auto = +1 year
}

export interface PacketRecord {
  id: string; // Unique GUID
  systemRef: string; // The "2026 GK STU ..." ref
  studentName: string;
  institution: string;
  term: string;
  generatedAt: string; // ISO Date string
  includedDocs: string[]; // List of doc names enabled
  status: 'Draft' | 'Generated';
  dataSnapshot: StudentVerificationData; // Complete immutable snapshot
  pdfSettingsSnapshot: PdfSettings;
}
