import { StudentVerificationData, PdfSettings as StudentPdfSettings } from './student-verification';
import { VerificationData as MilitaryVerificationData } from '@/lib/generator';

export type RecordType = 'MILITARY' | 'STUDENT';

export interface BaseRecord {
  id: string;
  systemRef: string;
  generatedAt: string;
  type: RecordType;
  status: 'DRAFT' | 'GENERATED' | 'ARCHIVED';
  isLocked?: boolean; // For "official" look
}

// Military Record (based on RecordEditor)
export interface MilitaryRecord extends BaseRecord {
  type: 'MILITARY';
  details: {
    name: string;
    branch: string;
    rank?: string;
    dischargeDate?: string;
  };
  data: MilitaryVerificationData;
}

// Student Record (based on StudentVerificationForm)
export interface StudentRecord extends BaseRecord {
  type: 'STUDENT';
  details: {
    name: string;
    institution: string;
    program?: string;
    term?: string;
  };
  data: StudentVerificationData;
  pdfSettings: StudentPdfSettings;
}

export type ServiceRecord = MilitaryRecord | StudentRecord;

export const STORAGE_KEY_RECORDS = 'genekei_service_records';
