import { VerificationData } from './generator';

export function validateVerificationData(data: Partial<VerificationData>): Record<string, string> {
  const errors: Record<string, string> = {};

  if (!data.status) errors.status = "Status is required";
  if (!data.branch) errors.branch = "Branch is required";
  if (!data.firstName) errors.firstName = "First name is required";
  if (!data.lastName) errors.lastName = "Last name is required";
  if (!data.dob) errors.dob = "Date of birth is required";
  if (!data.startDate) errors.startDate = "Start date is required";
  if (!data.dischargeDate) errors.dischargeDate = "Discharge date is required";
  
  if (!data.email) {
    errors.email = "Email is required";
  } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(data.email)) {
    errors.email = "Invalid email format";
  }

  // Date logic checks
  if (data.dob && data.startDate) {
      const minEnlistment = new Date(data.dob);
      minEnlistment.setFullYear(minEnlistment.getFullYear() + 18);
      // Reset hours to compare dates only?
      // Or just simple comparison.
      if (data.startDate < minEnlistment) {
          errors.startDate = "Must be at least 18 years old to enlist";
      }
  }
  
  if (data.startDate && data.dischargeDate) {
      if (data.dischargeDate <= data.startDate) {
          errors.dischargeDate = "Discharge date must be after start date";
      }
  }

  return errors;
}
