import { PrismaClient } from '@prisma/client';

const prismaClientSingleton = () => {
  const isProd = process.env.NODE_ENV === 'production';
  
  // Construct Prisma options
  let outputUrl = process.env.DATABASE_URL;

  // Enhance URL with SSL settings if requested via generic env vars (common in cPanel)
  if (outputUrl && process.env.DB_SSL === 'true') {
     // If URL doesn't already have ssl assertions, append them
     if (!outputUrl.includes('sslmode=') && !outputUrl.includes('sslcert=')) {
        const separator = outputUrl.includes('?') ? '&' : '?';
        const trust = process.env.DB_SSL_REJECT_UNAUTHORIZED === 'false' ? 'no-verify' : 'require';
        outputUrl = `${outputUrl}${separator}sslmode=${trust}`;
     }
  }

  return new PrismaClient({
    datasources: {
      db: {
        url: outputUrl,
      },
    },
    // Log queries in dev for easier debugging
    log: isProd ? ['error'] : ['query', 'error', 'warn'],
  });
};

declare global {
  var prisma: undefined | ReturnType<typeof prismaClientSingleton>;
}

const prisma = globalThis.prisma ?? prismaClientSingleton();

export default prisma;

if (process.env.NODE_ENV !== 'production') {
  globalThis.prisma = prisma;
}
