"use client";

import { useState, useEffect } from 'react';
import { PacketRecord, StudentVerificationData, PdfSettings } from '@/types/student-verification';

const STORAGE_KEY = 'genekei_student_packet_history';

export function usePacketHistory() {
  const [history, setHistory] = useState<PacketRecord[]>([]);

  // Load from local storage on mount
  useEffect(() => {
    const stored = localStorage.getItem(STORAGE_KEY);
    if (stored) {
      try {
        setHistory(JSON.parse(stored));
      } catch (e) {
        console.error("Failed to parse packet history:", e);
      }
    }
  }, []);

  const saveRecord = (record: PacketRecord) => {
    setHistory(prev => {
      const updated = [record, ...prev]; // Newest first
      localStorage.setItem(STORAGE_KEY, JSON.stringify(updated));
      return updated;
    });
  };

  const deleteRecord = (id: string) => {
    setHistory(prev => {
      const updated = prev.filter(r => r.id !== id);
      localStorage.setItem(STORAGE_KEY, JSON.stringify(updated));
      return updated;
    });
  };

  const clearHistory = () => {
    setHistory([]);
    localStorage.removeItem(STORAGE_KEY);
  };

  return {
    history,
    saveRecord,
    deleteRecord,
    clearHistory
  };
}
