"use client";

import React, { createContext, useContext, useState, useEffect } from 'react';

type UserRole = 'ADMIN' | 'OPERATOR';

interface RoleContextType {
  role: UserRole;
  setRole: (role: UserRole) => void;
  isAdmin: boolean;
}

const RoleContext = createContext<RoleContextType | undefined>(undefined);

export function RoleProvider({ children }: { children: React.ReactNode }) {
  const [role, setRole] = useState<UserRole>('ADMIN');

  useEffect(() => {
    // Persist mock role for demo sessions
    const saved = sessionStorage.getItem('mock_user_role');
    if (saved === 'ADMIN' || saved === 'OPERATOR') {
      setRole(saved);
    }
  }, []);

  const updateRole = (newRole: UserRole) => {
    setRole(newRole);
    sessionStorage.setItem('mock_user_role', newRole);
  };

  return (
    <RoleContext.Provider value={{ role, setRole: updateRole, isAdmin: role === 'ADMIN' }}>
      {children}
    </RoleContext.Provider>
  );
}

export function useRole() {
  const context = useContext(RoleContext);
  if (context === undefined) {
    throw new Error('useRole must be used within a RoleProvider');
  }
  return context;
}
