import React from 'react';
import { ChevronDown } from 'lucide-react';

interface SelectProps extends React.SelectHTMLAttributes<HTMLSelectElement> {
  error?: boolean;
}

export function Select({ className = '', error, children, ...props }: SelectProps) {
  return (
    <div className="relative">
      <select
        className={`
          appearance-none flex h-10 w-full rounded-lg border bg-white px-3 py-2 pr-8 text-sm text-gray-900 
          transition-all focus:outline-none focus:ring-2 focus:ring-offset-1 disabled:cursor-not-allowed disabled:opacity-50
          ${error 
            ? 'border-red-500 focus:border-red-500 focus:ring-red-200' 
            : 'border-gray-200 hover:border-gray-300 focus:border-blue-500 focus:ring-blue-200'
          }
          ${className}
        `}
        {...props}
      >
        {children}
      </select>
      <div className="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
        <ChevronDown className="h-4 w-4" />
      </div>
    </div>
  );
}
