import React from 'react';

interface InputProps extends React.InputHTMLAttributes<HTMLInputElement> {
  error?: boolean;
}

export function Input({ className = '', error, ...props }: InputProps) {
  return (
    <input
      className={`
        flex h-10 w-full rounded-lg border bg-white px-3 py-2 text-sm text-gray-900 placeholder:text-gray-400 
        transition-all file:border-0 file:bg-transparent file:text-sm file:font-medium 
        focus:outline-none focus:ring-2 focus:ring-offset-1 disabled:cursor-not-allowed disabled:opacity-50
        ${error 
          ? 'border-red-500 focus:border-red-500 focus:ring-red-200' 
          : 'border-gray-200 hover:border-gray-300 focus:border-blue-500 focus:ring-blue-200'
        }
        ${className}
      `}
      {...props}
    />
  );
}
