import React from 'react';
import { X } from 'lucide-react';

interface DialogProps {
    open: boolean;
    onOpenChange: (open: boolean) => void;
    children: React.ReactNode;
}

export function Dialog({ open, onOpenChange, children }: DialogProps) {
    if (!open) return null;

    return (
        <div className="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm">
             <div className="fixed inset-0" onClick={() => onOpenChange(false)} />
             {children}
        </div>
    );
}

export function DialogContent({ children, className = '' }: { children: React.ReactNode, className?: string }) {
    return (
        <div className={`relative z-50 w-full max-w-md bg-white dark:bg-slate-900 rounded-lg shadow-xl border border-slate-200 dark:border-slate-800 p-6 animate-in fade-in zoom-in-95 duration-200 ${className}`}>
            {children}
        </div>
    );
}

export function DialogHeader({ children }: { children: React.ReactNode }) {
    return <div className="mb-4 space-y-1.5 text-center sm:text-left">{children}</div>;
}

export function DialogTitle({ children }: { children: React.ReactNode }) {
    return <h2 className="text-lg font-semibold leading-none tracking-tight">{children}</h2>;
}

export function DialogFooter({ children }: { children: React.ReactNode }) {
    return <div className="mt-6 flex flex-col-reverse sm:flex-row sm:justify-end sm:space-x-2">{children}</div>;
}

export function DialogTrigger({ children, asChild, onClick, className }: { children: React.ReactNode, asChild?: boolean, onClick?: () => void, className?: string }) {
    // Basic implementation that just passes the click handler if provided by parent (Dialog context needed for full implementation, but for now parent controls state mostly)
    // Note: In this simple version, we assume the parent controls `open` state or passes `onClick`. 
    // If we want it to work automatically, we need a Context for the Dialog.
    // For now, let's just render the children.
    return <div className={className} onClick={onClick}>{children}</div>;
}
