"use client";

import React, { useState, useEffect } from 'react';
import { Clock } from 'lucide-react';

export const ZuluClock = () => {
  const [time, setTime] = useState<string>('');

  useEffect(() => {
    // Initial set
    updateTime();

    const interval = setInterval(updateTime, 1000);
    return () => clearInterval(interval);

    function updateTime() {
        const now = new Date();
        // Format: HHMM:SS Z
        const hours = now.getUTCHours().toString().padStart(2, '0');
        const minutes = now.getUTCMinutes().toString().padStart(2, '0');
        const seconds = now.getUTCSeconds().toString().padStart(2, '0');
        setTime(`${hours}${minutes}:${seconds} Z`);
    }
  }, []);

  // Prevent hydration mismatch by rendering nothing initially or a placeholder
  if (!time) return <div className="w-24 h-5 animate-pulse bg-emerald-900/20 rounded"></div>;

  return (
    <div className="flex items-center space-x-2 text-xs font-mono text-emerald-500 bg-black/20 px-2 py-1 rounded border border-emerald-500/10">
      <Clock className="w-3 h-3" />
      <span className="tracking-widest font-bold">{time}</span>
    </div>
  );
};
