"use client";

import React from 'react';
import { useRole } from '@/contexts/RoleContext';
import { Shield, ShieldAlert, User } from 'lucide-react';

export function RoleSimulator() {
  const { role, setRole, isAdmin } = useRole();

  return (
    <div className="fixed bottom-4 right-4 z-50 flex items-center bg-slate-900 text-white rounded-full p-1 pl-3 shadow-lg border border-slate-700">
        <div className="flex items-center text-xs font-mono mr-2">
            {isAdmin ? <ShieldAlert className="w-3 h-3 mr-1 text-red-400" /> : <User className="w-3 h-3 mr-1 text-blue-400" />}
            <span className={isAdmin ? 'text-red-400 font-bold' : 'text-blue-400'}>
                {role} MODE
            </span>
        </div>
        <div className="flex bg-slate-800 rounded-full p-0.5">
            <button
                onClick={() => setRole('OPERATOR')}
                className={`px-3 py-1 rounded-full text-[10px] font-bold transition-all ${!isAdmin ? 'bg-blue-600 text-white shadow-sm' : 'text-slate-400 hover:text-slate-200'}`}
            >
                OP
            </button>
            <button
                onClick={() => setRole('ADMIN')}
                className={`px-3 py-1 rounded-full text-[10px] font-bold transition-all ${isAdmin ? 'bg-red-600 text-white shadow-sm' : 'text-slate-400 hover:text-slate-200'}`}
            >
                ADM
            </button>
        </div>
    </div>
  );
}
