"use client";

import React from 'react';
import { Menu, Shield, FileText, User, Settings, Search, Bell, Bot, GraduationCap } from 'lucide-react';
import { ZuluClock } from '@/components/ZuluClock';
import Link from 'next/link';
import { usePathname } from 'next/navigation';

interface DashboardLayoutProps {
  children: React.ReactNode;
}

export const DashboardLayout = ({ children }: DashboardLayoutProps) => {
  const pathname = usePathname();
  return (
    <div className="min-h-screen bg-slate-100 dark:bg-slate-900 font-sans text-slate-900 dark:text-slate-100 flex">
      {/* Sidebar */}
      <aside className="w-64 bg-slate-900 text-slate-300 flex-shrink-0 hidden md:flex flex-col border-r border-slate-700">
        <div className="h-16 flex items-center px-6 border-b border-slate-700 bg-slate-950">
           <Shield className="w-6 h-6 text-emerald-500 mr-2" />
           <span className="font-bold text-white tracking-wider">GENEKEI<span className="text-emerald-500">SYS</span></span>
        </div>
        
        <div className="p-4">
          <div className="text-xs font-mono text-slate-500 mb-2 uppercase tracking-widest">System</div>
          <nav className="space-y-1">
            <Link href="/" className={`flex items-center w-full px-3 py-2 rounded-md text-sm font-medium transition-colors ${pathname === '/' ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white'}`}>
              <FileText className={`w-4 h-4 mr-3 ${pathname === '/' ? 'text-emerald-400' : ''}`} />
              Service Records
            </Link>
            <Link href="/sheerid" className={`flex items-center w-full px-3 py-2 rounded-md text-sm font-medium transition-colors ${pathname === '/sheerid' ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white'}`}>
              <Bot className={`w-4 h-4 mr-3 ${pathname === '/sheerid' ? 'text-emerald-400' : ''}`} />
              SheerID Bot
            </Link>
            <Link href="/student-verify" className={`flex items-center w-full px-3 py-2 rounded-md text-sm font-medium transition-colors ${pathname === '/student-verify' ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white'}`}>
              <GraduationCap className={`w-4 h-4 mr-3 ${pathname === '/student-verify' ? 'text-emerald-400' : ''}`} />
              Student Verification
            </Link>
            <Link href="/personnel" className={`flex items-center w-full px-3 py-2 rounded-md text-sm font-medium transition-colors ${pathname === '/personnel' ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white'}`}>
              <User className={`w-4 h-4 mr-3 ${pathname === '/personnel' ? 'text-emerald-400' : ''}`} />
              Personnel
            </Link>
            <Link href="/configuration" className={`flex items-center w-full px-3 py-2 rounded-md text-sm font-medium transition-colors ${pathname === '/configuration' ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white'}`}>
              <Settings className={`w-4 h-4 mr-3 ${pathname === '/configuration' ? 'text-emerald-400' : ''}`} />
              Configuration
            </Link>
          </nav>
        </div>

        <div className="mt-auto p-4 border-t border-slate-800">
            <div className="flex items-center">
                <div className="w-8 h-8 rounded-full bg-emerald-900 flex items-center justify-center border border-emerald-500/30">
                    <span className="text-xs font-bold text-emerald-400">ADM</span>
                </div>
                <div className="ml-3">
                    <p className="text-sm font-medium text-white">CPT. Admin</p>
                    <p className="text-xs text-slate-500">System Operator</p>
                </div>
            </div>
        </div>
      </aside>

      {/* Main Content */}
      <div className="flex-1 flex flex-col min-w-0 overflow-hidden">
        {/* Top Bar */}
        <header className="bg-white dark:bg-slate-800 shadow-sm z-10">

            <div className="h-16 flex items-center justify-between px-6 border-b border-slate-200 dark:border-slate-700">
                <div className="flex items-center">
                    <button className="md:hidden mr-4 text-slate-500 hover:text-slate-700">
                        <Menu className="w-6 h-6" />
                    </button>
                    <div className="hidden md:flex items-center text-sm breadcrumbs text-slate-500">
                        <span className="hover:text-slate-700 cursor-pointer">System</span>
                        <span className="mx-2">/</span>
                        <span className="hover:text-slate-700 cursor-pointer">Records</span>
                        <span className="mx-2">/</span>
                        <span className="font-semibold text-slate-900 dark:text-slate-100">DD-214 Processor</span>
                    </div>
                </div>

                <div className="flex items-center space-x-4">
                    <div className="relative">
                        <Search className="w-4 h-4 absolute left-3 top-1/2 transform -translate-y-1/2 text-slate-400" />
                        <input 
                            type="text" 
                            placeholder="Search records..." 
                            className="pl-9 pr-4 py-1.5 text-sm border border-slate-300 dark:border-slate-600 rounded-full bg-slate-50 dark:bg-slate-900 focus:outline-none focus:ring-2 focus:ring-emerald-500 w-64"
                        />
                    </div>
                    <button className="text-slate-400 hover:text-slate-600 relative">
                        <Bell className="w-5 h-5" />
                        <span className="absolute top-0 right-0 w-2 h-2 bg-red-500 rounded-full"></span>
                    </button>
                    <div className="h-4 w-px bg-slate-300 dark:bg-slate-600 mx-2"></div>
                    <ZuluClock />
                    <div className="h-4 w-px bg-slate-300 dark:bg-slate-600 mx-2"></div>
                    <div className="flex items-center space-x-2 text-xs font-mono text-emerald-600 bg-emerald-50 dark:bg-emerald-900/20 px-2 py-1 rounded">
                        <div className="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></div>
                        <span>SYSTEM ONLINE</span>
                    </div>
                </div>
            </div>
        </header>

        {/* Scrollable Content */}
        <main className="flex-1 overflow-y-auto bg-slate-50 dark:bg-slate-950 p-6">
            <div className="max-w-7xl mx-auto">
                {children}
            </div>
            
            {/* Footer Legal */}
            <div className="mt-8 pt-6 border-t border-slate-200 dark:border-slate-800 text-center">
                <p className="text-xs text-slate-400">
                    US DEPARTMENT OF DEFENSE FORM SIMULATOR // VER 2.1.0 // GENEKEI SYSTEMS
                </p>
                <p className="text-[10px] text-slate-300 mt-1">
                    THIS SYSTEM IS FOR DEMONSTRATION PURPOSES ONLY. NOT CONNECTED TO GOVERNMENT DATABASES.
                </p>
            </div>
        </main>
      </div>
    </div>
  );
};
