import { NextResponse } from 'next/server';
import prisma from '@/lib/prisma';

export async function GET() {
  try {
    const templates = await prisma.template.findMany({
      orderBy: { createdAt: 'desc' },
    });
    return NextResponse.json({ ok: true, templates: templates.map(t => t.payload) }); // Assuming payload is the full template object
  } catch (error: any) {
    console.error('Failed to fetch templates:', error);
    return NextResponse.json({ ok: false, error: 'Failed to fetch templates' }, { status: 500 });
  }
}

export async function POST(request: Request) {
  try {
    const body = await request.json();
    const { template } = body;

    if (!template || !template.id || !template.name) {
        return NextResponse.json({ ok: false, error: 'Invalid template data' }, { status: 400 });
    }

    await prisma.template.create({
        data: {
            id: template.id,
            kind: template.kind || 'packet',
            name: template.name,
            payload: template,
        }
    });

    return NextResponse.json({ ok: true });
  } catch (error: any) {
    console.error('Failed to save template:', error);
    return NextResponse.json({ ok: false, error: 'Failed to save template' }, { status: 500 });
  }
}
