import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  output: "standalone",
  webpack: (config) => {
    config.resolve.alias.canvas = false;
    config.resolve.alias.encoding = false;
    return config;
  },
  experimental: {
    turbo: {
      resolveAlias: {
        canvas: './src/lib/canvas-mock.js', // Turbopack needs a file
        encoding: './src/lib/encoding-mock.js',
      }
    }
  }
};

export default nextConfig;
