# Manual Verification Checklist

Use this checklist to verify the deployment on cPanel.

## 1. Initial Deployment Checks
- [ ] **Access Site**: Visit `https://app.yourdomain.com`.
  - [ ] Page loads (Status 200).
  - [ ] Styles are applied (CSS not 404).
  - [ ] Images load correctly.

## 2. Environment & Database
- [ ] **Health Check**:
  - Run: `curl -I -H "x-health-token: YOUR_TOKEN" https://app.yourdomain.com/api/health/db`
  - Expected: `200 OK`, JSON body `ok: true`.
- [ ] **Authentication** (if applicable):
  - [ ] Attempt login/signup (verifies DB writes).
  - [ ] Verify persistence (refresh page).

## 3. Subdomain Specifics
- [ ] **Links**: Click valid internal links.
  - [ ] Verify URL stays on subdomain (doesn't redirect to main domain or localhost).
- [ ] **Cookies**: Check browser dev tools (Application -> Cookies).
  - [ ] Ensure cookies are set for the correct domain.

## 4. Error Handling
- [ ] **Not Found**: Visit a non-existent route (`/random-123`).
  - [ ] Verify 404 page checks out.
- [ ] **DB Failure Simulation**:
  - Temporarily change `DB_PASSWORD` or `DB_SSL` in cPanel to invalid.
  - Restart App.
  - Visit Health Check -> Should return `500` with safe error details.
  - **Revert** change and restart.

## 5. Persistence
- [ ] **App Restart**:
  - Go to cPanel -> Node.js App -> Restart.
  - Refresh site immediately -> Should might hang for 10s then load.
  - Verify data is still there.
