# Deployment Guide (cPanel + Node.js + PostgreSQL)

This guide covers how to deploy the **Genekei** Next.js application to a cPanel environment with a PostgreSQL database.

## Prerequisites

- **cPanel Account** with:
  - **Node.js App** support (Phusion Passenger / CloudLinux).
  - **PostgreSQL** support.
  - **File Manager** or **Terminal** (SSH) access.
  - **Subdomain** created (e.g., `app.genekei.com`).

---

## 1. Prepare cPanel Environment

### A. Create Subdomain
1. Log in to cPanel.
2. Go to **Domains** -> **Create A New Domain**.
3. Enter your subdomain (e.g., `app.yourdomain.com`).
4. Ensure the **Document Root** is set (e.g., `/home/username/app.yourdomain.com`), ensuring it doesn't conflict with other sites.
   *Note: Next.js Standalone runs on a port, so this document root is mostly for static asset fallback or placeholder.*

### B. Create PostgreSQL Database
1. Go to **PostgreSQL Database Wizard** in cPanel.
2. **Create Database**: e.g., `genekei_production`.
   *Note: cPanel will prepend your username (e.g., `username_genekei_production`).*
3. **Create User**: e.g., `genekei_user`.
   *Note: cPanel will prepend your username (e.g., `username_genekei_user`).*
4. **Grant Privileges**: Assign the user to the database with **ALL PRIVILEGES**.
5. **Record Credentials**:
   - **Database**: `username_genekei_production`
   - **User**: `username_genekei_user`
   - **Password**: (The one you set)
   - **Host**: Usually `localhost` or `127.0.0.1`. If typically fails, check cPanel documentation (sometimes `/tmp`).

---

## 2. Upload Project Files

You need to upload the source code to the server. Git is recommended, but you can also use ZIP upload.

### Recommended Directory Structure
Create a folder for your app **outside** public_html to keep source code secure.
`Min Path: /home/<username>/apps/genekei`

### Method: File Manager / ZIP
1. Locally, run:
   ```bash
   # Remove local system-dependent folders
   rm -rf .next node_modules
   ```
2. Zip the entire project folder (excluding .git, .next, node_modules).
3. Upload to `/home/<username>/apps/genekei` via cPanel File Manager.
4. Extract the ZIP.

---

## 3. Configure Node.js App

1. Go to **Setup Node.js App** in cPanel.
2. Click **Create Application**.
3. **Settings**:
   - **Node.js Version**: Select highest available (e.g., 20.x, 18.x).
   - **Application Mode**: `Production`.
   - **Application Root**: `/home/<username>/apps/genekei` (The path where you uploaded files).
   - **Application URL**: Select your subdomain (e.g., `app.genekei.com`).
   - **Application Startup File**: `.next/standalone/server.js`
     *Important: This file won't exist yet, but type it in exactly.*
4. Click **Create**.

---

## 4. Install Dependencies & Build

1. Inside the Node.js App page, copied the command line to enter the virtual environment:
   *(e.g., `source /home/username/nodevenv/apps/genekei/20/bin/activate && cd /home/username/apps/genekei`)*
2. Open **Terminal** in cPanel.
3. Paste the command to enter the environment.
4. Run installation and build:
   ```bash
   # Install dependencies (production only is often enough, but build needs devDeps types)
   npm install
   
   # Build the application
   # This generates the .next/standalone/server.js file
   npm run build
   
   # Verify server.js exists
   ls -la .next/standalone/server.js
   ```

---

## 5. Configure Environment Variables

1. Go back to **Setup Node.js App**.
2. Click **Add Variable**:
   - `NODE_ENV`: `production`
   - `PORT`: (Leave empty or don't set, cPanel sets this automatically via Passenger, but Next.js Standalone respects `PORT`. Usually cPanel uses a named pipe. If you encounter issues, try setting `PORT` to a number like `3000` just in case, but usually leave it.)
   - `NEXT_PUBLIC_APP_URL`: `https://app.yourdomain.com`
   - `DATABASE_URL`: `postgresql://user:pass@localhost:5432/db_name?schema=public`
   - `HEALTHCHECK_TOKEN`: (Your random secure string)
   - `DB_SSL`: `false` (Set to `true` if cPanel requires it)
   - `DB_SSL_REJECT_UNAUTHORIZED`: `false` (Often needed for self-signed cPanel certs)
3. Click **Save**.

---

## 6. Run Database Migrations

In the Terminal (inside the virtual environment):
```bash
npm run db:migrate
```
*This runs `prisma migrate deploy` to check schema sync.*

---

## 7. Start the Application

1. Go to **Setup Node.js App**.
2. Click **Restart Application**.
3. Wait about 30 seconds for the application to boot.

---

## 8. Verification

1. **Visit Website**: Open `https://app.yourdomain.com`.
2. **Health Check**:
   Replace `<TOKEN>` with your `HEALTHCHECK_TOKEN`:
   ```bash
   curl -I -H "x-health-token: <TOKEN>" https://app.genekei.com/api/health/db
   ```
   Should return `200 OK` and JSON with DB version.

---

## Troubleshooting

### "Internal Server Error" / 500
- Check **stderr.log** in the application root using File Manager.
- Ensure `.next/standalone/server.js` exists. If not, run `npm run build` again.
- Ensure `DATABASE_URL` is correct.

### Database Connection Failures
- Error: `P1001: Can't reach database server` -> Check Host (`localhost` vs `127.0.0.1`) and Port (5432).
- Error: `SSL off` -> Set `DB_SSL=true`.
- Error: `SASL authentication` -> Ensure password doesn't contain strict special characters confusing the URL parser (URL encode them if needed).

### Static Assets 404
- The Standalone build puts static files in `.next/static`. 
- Ensure your `next.config.ts` has `output: 'standalone'`.
- Copy static files to public if needed (usually handled automatically by Next.js standalone logic respecting `public/` and `_next/static`).
  *If images break:* You may need to copy `.next/static` to `public/_next/static` manually in some strict cPanel configs, but usually `server.js` handles it.
