# Database Setup & Verification Guide

## 1. Configure Environment Variables
I have created a `.env.local` file for you. You need to edit it to add your actual database password.

**Action:** Open `.env.local` and replace `<PASSWORD>` with your `genekei_user` password.

```env
DATABASE_URL="postgresql://genekei_user:YOUR_PASSWORD_HERE@localhost:5432/genekei?schema=public"
# ... other vars ...
PGPASSWORD=YOUR_PASSWORD_HERE

# Set this to true to enable the DB syncing feature
NEXT_PUBLIC_ENABLE_DB_PERSISTENCE=true 
```

## 2. Restart Development Server
Next.js loads environment variables on startup. You must restart the server for the new variables to take effect.

**Action:**
1. Stop the running server (Ctrl+C).
2. Run `npm run dev` again.

## 3. Verify Database Connection (Health Check)
I have created a dedicated API route to test the connection.

**Action:** Open this URL in your browser:
[http://localhost:3000/api/health/db](http://localhost:3000/api/health/db)
*(Note: If your app is running on port 3001, adjust the URL accordingly)*

**Success Response (JSON):**
```json
{
  "ok": true,
  "db": "genekei",
  "user": "genekei_user",
  "version": "PostgreSQL 16.x ..."
}
```

**Failure Response:**
```json
{
  "ok": false,
  "error": "Database connection failed",
  "details": "..."
}
```

## 4. Verify Record Persistence
The application is now wired to verify and create the necessary table (`service_records`) automatically when you use the API.

**Action:**
1. Make sure `NEXT_PUBLIC_ENABLE_DB_PERSISTENCE=true` is set in `.env.local`.
2. Generate a new record in the app (e.g., maintain a student packet).
3. The app will automatically try to save it to your local Postgres database.
4. You can verify this in pgAdmin by running:
   ```sql
   SELECT * FROM service_records;
   ```
